/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于根据箱体xml描述字串,箱体下所有模组xml描述字串,箱体常规参数
 *   ,箱体寄存器相关参数,箱体gamma参数生成md5值
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.09.14
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_box_param_md5 */
/* exported mc_crypto_set_box_md5_to_key */
/* exported mc_crypto_set_recvcard_md5_to_key */

/* global md5 */

/************************************************************************************************
* 类型:
*    构造函数
* 功能:
*    解析箱体数据,将箱体数据解析为md5值储存
* 参数:
*    NA
* 返回：
*    NA
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.9.14
*      内容 : 所有代码
************************************************************************************************/
function mc_box_param_md5() {
    var m_str_rec_xml_md5 = "";
    var m_str_normal_param_md5 = "";
    var m_str_disp_reg_item_md5 = "";
    var m_str_scan_reg_item_md5 = "";
    var m_str_disp_reg_list_md5 = "";
    var m_str_scan_reg_list_md5 = "";
    var m_str_gamma_md5 = "";


    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    添加箱体xml字符串,解析为md5值存入
     * 参数:
     *     @param {Promise<Object>} obj_box_msg 箱体链接页面生成数据
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_rec_xml_md5 = function (obj_box_msg) {
        var str_md5_val = "";
        // 获取控制芯片名称
        var str_chip_id = obj_box_msg.ctrlchip_name;
        // 获取hub芯片名称
        var str_hub_id = obj_box_msg.hub_name;

        str_md5_val = str_chip_id + str_hub_id;
        // 不详不过就是要拿来计算
        var obj_edit_val = obj_box_msg.edit_val;

        if (
            obj_edit_val &&
            "object" === typeof obj_edit_val &&
            0 < Object.keys(obj_edit_val).length
        ) {
            str_md5_val += obj_edit_val.str_name + obj_edit_val.str_iccount + obj_edit_val.str_all_use_dat_cnt;

            var ary_child_pin = obj_edit_val.ary_child_pin;

            for (var idx_pin = 0; idx_pin < ary_child_pin.length; idx_pin++) {
                var obj_child_pin = ary_child_pin[idx_pin];

                str_md5_val += obj_child_pin.str_subname +
                obj_child_pin.str_use_dat_pin_count +
                obj_child_pin.str_use_ctl_pin_count +
                obj_child_pin.str_dat_pin_cnt +
                obj_child_pin.ary_st_dat +
                obj_child_pin.ary_st_ctl;
            }
        }

        // 排序modlist 从最小jx 的列表开始获取md5值
        var ary_jx_list = obj_box_msg.data;
        var ary_jx_val = [];

        for (var idx_list = 0; idx_list < ary_jx_list.length; idx_list++) {
            var obj_jx_data = ary_jx_list[idx_list];
            var str_jx_num = obj_jx_data.jx_num;
            var ary_mod_list = obj_jx_data.children;
            var str_mod_val = "";

            for (var idx_modlist = 0; idx_modlist < ary_mod_list.length; idx_modlist++) {
                var obj_mod_data = ary_mod_list[idx_modlist];

                str_mod_val += obj_mod_data.module_name +
                obj_mod_data.mirror +
                obj_mod_data.offset_x +
                obj_mod_data.offset_y +
                obj_mod_data.rotation +
                obj_mod_data.scale +
                (obj_mod_data.cut || "0,0,0,0");
            }
            ary_jx_val[str_jx_num] = str_mod_val;
        }
        str_md5_val += ary_jx_val;
        m_str_rec_xml_md5 = str_md5_val;
        return;
    };

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    添加箱体常规参数返回参数字符串,解析为md5值存入
     * 参数:
     *     @param {Promise<Object>} obj_sdk_param 常规参数返回参数
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_normal_param_md5 = function (obj_sdk_param) {
        m_str_normal_param_md5 = mc_sort_param_value(obj_sdk_param);
        return;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    添加箱体显示芯片寄存器项字符串,解析为md5值存入
     * 参数:
     *     @param {Promise<Object>} obj_sdk_param 显示芯片寄存器项
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_disp_reg_item_md5 = function (obj_sdk_param) {
        m_str_disp_reg_item_md5 = mc_sort_param_value(obj_sdk_param);
        return;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    添加箱体行管芯片寄存器项字符串,解析为md5值存入
     * 参数:
     *     @param {Promise<Object>} obj_sdk_param 行管芯片寄存器项
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_scan_reg_item_md5 = function (obj_sdk_param) {
        m_str_scan_reg_item_md5 = mc_sort_param_value(obj_sdk_param);
        return;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    添加箱体显示芯片寄存器列表字符串,解析为md5值存入
     * 参数:
     *     @param {Promise<Object>} obj_sdk_param 显示芯片寄存器列表
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_disp_reg_list_md5 = function (obj_sdk_param) {
        m_str_recvcard_param_md5 = mc_sort_param_value(obj_sdk_param);
        return;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    添加箱体行管芯片寄存器列表字符串,解析为md5值存入
     * 参数:
     *     @param {Promise<Object>} obj_sdk_param 行管芯片寄存器列表
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_scan_reg_list_md5 = function (obj_sdk_param) {
        m_str_scan_reg_list_md5 = mc_sort_param_value(obj_sdk_param);
        return;
    };
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    添加箱体gamma字符串,解析为md5值存入
     * 参数:
     *     @param {Promise<Array>} ary_gamma_list gamma数据
     * 返回：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_gamma_md5 = function (ary_gamma_list) {
        if (!Array.isArray(ary_gamma_list) || 0 >= ary_gamma_list.length) {
            return;
        }
        var str_gamma_md5_val = "";

        for (var idx_gamma = 0; idx_gamma < ary_gamma_list.length; idx_gamma++) {
            var obj_gamma_data = ary_gamma_list[idx_gamma];
            var str_gamma_data = obj_gamma_data.data;

            str_gamma_md5_val += str_gamma_data;
        }

        m_str_gamma_md5 = str_gamma_md5_val;
        return;
    };

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    为箱体对象添加获取箱体md5值方法,
     * 参数:
     *     NA
     * 返回：
     *    @returns {Promise<String>} 箱体xmlmd5 + 从jx最小到最大所有模组xml计算的md5值 + 箱体常规参数sdk返回参数md5值 +
     *                               显示芯片寄存器项md5 + 行管芯片寄存器项md5 +显示芯片寄存器列表md5 + 行管芯片寄存器列表md5
     *                                + gamma md5 + 箱体接收卡数据
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.14
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_box_md5 = function () {
        var str_return_md5 = m_str_rec_xml_md5 + m_str_normal_param_md5 +
        m_str_disp_reg_item_md5 + m_str_scan_reg_item_md5 +
        m_str_disp_reg_list_md5 + m_str_scan_reg_list_md5 + m_str_gamma_md5;

        return md5(str_return_md5);
    };
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    为箱体对象添加获取箱体md5值方法,并监听对应属性,当属性修改时重新存入数据重新计算对应md5值
* 参数:
*     @param {Promise<Object>} obj_data 绑定对象
* 返回：
*    @returns {Promise<String>} 计算箱体md5值
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.9.14
*      内容 : 所有代码
************************************************************************************************/
function mc_crypto_set_box_md5_to_key(obj_data) {
    if (
        "function" !== typeof obj_data.data.mc_util_get_resul ||
        "function" !== typeof obj_data.data.mc_util_get_disp_reg ||
        "function" !== typeof obj_data.data.mc_util_get_scan_reg ||
        "function" !== typeof obj_data.data.mc_util_get_disp_reg_list ||
        "function" !== typeof obj_data.data.mc_util_get_scan_reg_list ||
        "function" !== typeof obj_data.data.mc_util_get_gamma_val ||
        "string" !== typeof obj_data.name || 0 >= obj_data.name.length
    ) {
        return "";
    }
    var obj_md5_data = new mc_box_param_md5();
    var obj_box_data = obj_data.data;

    obj_md5_data.set_rec_xml_md5(obj_box_data.mc_util_get_ui_box_msg());
    obj_md5_data.set_normal_param_md5(obj_box_data.mc_util_get_resul());
    obj_md5_data.set_disp_reg_item_md5(obj_box_data.mc_util_get_disp_reg());
    obj_md5_data.set_scan_reg_item_md5(obj_box_data.mc_util_get_scan_reg());
    obj_md5_data.set_disp_reg_list_md5(obj_box_data.mc_util_get_disp_reg_list());
    obj_md5_data.set_scan_reg_list_md5(obj_box_data.mc_util_get_scan_reg_list());
    obj_md5_data.set_gamma_md5(obj_box_data.mc_util_get_gamma_val());

    return obj_md5_data.get_box_md5();
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    计算箱体页面数据md5值
* 参数:
*     @param {Promise<Object>} obj_box_msg 箱体数据对象
* 返回：
*    @returns {Promise<String>} 计算箱体md5值
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.9.14
*      内容 : 所有代码
************************************************************************************************/
function mc_crypto_set_recvcard_md5_to_key(obj_box_msg) {
    var obj_md5_data = new mc_box_param_md5();

    obj_md5_data.set_rec_xml_md5(obj_box_msg);
    return obj_md5_data.get_box_md5();
}

/************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    冒泡排序数组,仅使用字符串对比排序
* 参数:
*     @param {Promise<Array>} ary_sorting_list 排序列表(内容为字符串)
* 返回：
*    @returns {Promise<Array>} 排序后的数组
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.9.15
*      内容 : 所有代码
************************************************************************************************/
function mc_bubble_sort(ary_sorting_list) {
    if (!Array.isArray(ary_sorting_list) || 0 >= ary_sorting_list.length) {
        return [];
    }
    var idx_i = ary_sorting_list.length, idx_j;
    var str_temp_data = "";

    while (0 < idx_i) {
        for (idx_j = 0; idx_j < idx_i - 1; idx_j++) {
            if (ary_sorting_list[idx_j] > ary_sorting_list[idx_j + 1]) {
                str_temp_data = ary_sorting_list[idx_j];
                ary_sorting_list[idx_j] = ary_sorting_list[idx_j + 1];
                ary_sorting_list[idx_j + 1] = str_temp_data;
            }
        }
        idx_i--;
    }
    return ary_sorting_list;
}
/************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    冒泡排序参数名称,获取参数内容字符串
* 参数:
*     @param {Promise<Object>} obj_sdk_param mc_sdk_param实例对象
* 返回：
*    @returns {Promise<String>} 排序后的参数内容
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.12.18
*      内容 : 所有代码
************************************************************************************************/
function mc_sort_param_value(obj_sdk_param) {
    if (!obj_sdk_param || 0 === obj_sdk_param.get_param_cnt()) {
        return "";
    }
    var ui_param_cnt = obj_sdk_param.get_param_cnt();
    var ary_param_name = [];
    var str_param_md5_val = "";

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_param_name = obj_sdk_param.get_param_name(idx_param);

        ary_param_name.push(str_param_name);
    }
    var ary_sorting_name = mc_bubble_sort(ary_param_name);

    for (var idx_sorting = 0; idx_sorting < ary_sorting_name.length; idx_sorting++) {
        var str_sorting_name = ary_sorting_name[idx_sorting];
        var str_param_val = obj_sdk_param.get_param_value(str_sorting_name);

        str_param_md5_val += str_param_val;
    }

    return str_param_md5_val;
}
